<?php
/**
 * @package   T3 Blank
 * @copyright Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license   GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$app = JFactory::getApplication();
$menu = $app->getMenu();
$lang = JFactory::getLanguage();
$hide_mainbody = (!$this->params->get("ZEN_MAINBODY_DISABLED",true)==false && ($menu->getActive() == $menu->getDefault( $lang->getTag() )));
$bodyimage = $this->params->get('bodyimage');
?>

<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
  <head>
    <jdoc:include type="head" />
    <?php $this->loadBlock ('head');?>  
 </head>
<body id="contentleft" class="<?php $this->bodyClass() ?><?php if ($this->checkSpotlight('banner', 'banner')) : ?> banner<?php endif; ?><?php if(isset($bodyimage)) { ?> bodyimage <?php } ?>">
  		<div id="fullwrap" <?php if($this->params->get('stickynav')) { ?>class="affix-top" data-spy="affix" data-offset-top="<?php echo $this->params->get('stickynavoffset') ?>"<?php } ?>>
  		<?php $this->loadBlock ('top') ?>
  		<div id="topcolour">
			<div id="topcolourinner">
  				<?php $this->loadBlock ('nav') ?>
				<?php $this->loadBlock ('logo') ?>
				<?php $this->loadBlock ('banner') ?>
			</div>
		</div>
		<div id="gradient">
			<div class="zen-container">			
				<?php $this->loadBlock ('tabs') ?>
				<?php $this->loadBlock ('grid1') ?>
				<?php $this->loadBlock ('grid2') ?>
				<?php $this->loadBlock ('grid3') ?>
				<?php if (!$hide_mainbody) : ?>
						<?php $this->loadBlock ('mainbody') ?>
				<?php endif; ?>
				<?php $this->loadBlock ('grid4') ?>
				<?php $this->loadBlock ('grid5') ?>
				<?php $this->loadBlock ('grid6') ?>
				<?php $this->loadBlock ('tabs2') ?>
				<?php $this->loadBlock ('bottom') ?>

			</div>
		</div>
		
    	<?php $this->loadBlock ('footer') ?>  
	 </div>
	 <div id="pixel"></div>
	 <?php if(isset($bodyimage)) { ?>
	 <img class="bgimage" src="<?php echo JURI::base(true) ?>/<?php echo $this->params->get('bodyimage') ?>" alt="bg Image" />
	 <?php } ?>
	 
	 <?php $this->loadBlock ('panel') ?>
	 <?php $this->loadBlock ('scripts') ?>
	<?php $this->loadBlock ('fonts') ?>
  </body>
</html>