
    AmCharts.ready(function() {
        // create AmMap object
        var map = new AmCharts.AmMap();
        // set path to images
        map.pathToImages = "ammap/images/";
		
		map.dragMap = false; //para que usuario no pueda arrastrar mapa.

        /* create data provider object
         map property is usually the same as the name of the map file.

         getAreasFromMap indicates that amMap should read all the areas available
         in the map data and treat them as they are included in your data provider.
         in case you don't set it to true, all the areas except listed in data
         provider will be treated as unlisted.
        */
        var dataProvider = {
            map: "mexicoLow",
            
			areas: [
			{id:"MX-AGU", color: "#023B4E", customData: "Tel: (449) 119-47-49 <br /> Web: www.frmedical.com.mx <br /> Correo: ventasags@frmedical.com.mx"},
			{id:"MX-BCN", color: "#023B4E", customData: "Tel: (686) 567-41-21 <br /> Web: www.bajacs.com <br /> Correo: mpereda@bajacs.com "},
			{id:"MX-CHH", color: "#023B4E", customData: "Tel: (614) 301-29-09, (656) 418-88-93 <br> Web: www.frmedical.com.mx <br> Correo: chihuahua@frmedical.com.mx, ventascuu@frmedical.com.mx"},
			
			{id:"MX-DIF", color: "#023B4E", customData: "Tel: (55) 53-74-11-33 <br /> Web: www.frmedical.com.mx  <br /> Correo: ventasmex@frmedical.com.mx"},
			{id:"MX-DUR", color: "#023B4E", customData: "Tel: "},
			{id:"MX-GUA", color: "#023B4E", customData: "Tel: (477) 367-93-92  <br> Web: www.frmedical.com.mx  <br> Correo: ventasgto@frmedical.com.mx"},
			{id:"MX-GRO", color: "#023B4E", customData: "Tel: "},
			{id:"MX-JAL", color: "#023B4E", customData: "Tel: (33) 17-28-45-70 <br> Web: www.frmedical.com.mx <br> Correo: ventasgdl@frmedical.com.mx"},
			{id:"MX-MEX", color: "#023B4E", customData: "Tel: (55) 53-74-11-33 <br> Web: www.frmedical.com.mx <br> Correo: ventasmex@frmedical.com.mx"},
			{id:"MX-MIC", color: "#023B4E", customData: "Tel: (443) 356-58-15 <br> Web: www.frmedical.com.mx <br> Correo: ventasmich@frmedical.com.mx"},
			{id:"MX-NLE", color: "#023B4E", customData: "Tel: (81) 19-37-40-20 <br> Web: www.frmedical.com.mx <br> Correo: ventasmty@frmedical.com.mx"},
			{id:"MX-PUE", color: "#023B4E", customData: "Tel: (222) 692-40-40 <br> Web: www.frmedical.com.mx <br> Correo: ventaspue@frmedical.com.mx"},
			{id:"MX-QUE", color: "#023B4E", customData: "Tel: (442) 516-47-00 <br> Web: www.frmedical.com.mx <br> Correo: ventasqro@frmedical.com.mx"},
			{id:"MX-ROO", color: "#023B4E", customData: "Tel: (998) 214-15-60 <br> Web: www.frmedical.com.mx <br> Correo: ventasyuc@frmedical.com.mx"},
			{id:"MX-SLP", color: "#023B4E", customData: "Tel: (444) 328-11-13 <br> Web: www.frmedical.com.mx <br> Correo: ventasslp@frmedical.com.mx"},
			{id:"MX-SIN", color: "#023B4E", customData: "Tel: (55) 49-99-38-22 <br> Web: www.frmedical.com.mx <br> Correo: ventassin@frmedical.com.mx"},
			{id:"MX-SON", color: "#023B4E", customData: "Tel: (662) 352-02-29 <br> Web: www.frmedical.com.mx <br> Correo: ventasson@frmedical.com.mx"},
			{id:"MX-TAM", color: "#023B4E", customData: "Tel: (81) 19-37-40-20 <br> Web: www.frmedical.com.mx <br> Correo: ventasmty@frmedical.com.mx "},
			{id:"MX-YUC", color: "#023B4E", customData: "Tel: (998) 214-15-60<br>Web: www.frmedical.com.mx<br>Correo: ventasyuc@frmedical.com.mx"}],
			
			//images:[{latitude:19.419444, longitude:-99.145556, type:"circle", color:"#ff0000", label:"New York", title:"FR Medical", description:"New York is the most populous city in the United States and the center of the New York Metropolitan Area, one of the most populous metropolitan areas in the world."}]
        }; 
        // pass data provider to the map object
        map.dataProvider = dataProvider;

        /* create areas settings
         * autoZoom set to true means that the map will zoom-in when clicked on the area
         * selectedColor indicates color of the clicked area.
         */
        map.areasSettings = {
            autoZoom: false,
            selectedColor: "#7998AC",
			unlistedAreasColor: "#DDDDDD",
			rollOverOutlineColor: "#FFFFFF",
			rollOverColor: "#7998AC",
			balloonText: "[[title]] <br> [[customData]]"
        };

        // let's say we want a small map to be displayed, so let's create it
        //map.smallMap = new AmCharts.SmallMap();
		
		//map.showDescriptionOnHover = true;
		var balloon = map.balloon;
		// set properties
		balloon.adjustBorderColor = true;
		balloon.color = "#000000";
		balloon.fillAlpha = 1;
		balloon.cornerRadius = 5;
		
		balloon.fillColor = "#FFFFFF";
		balloon.fixedPosition = true;
		//balloon.setPosition(0,0);
		balloon.fadeOutDuration = 10;
		
		var zoomControl = map.zoomControl
		zoomControl.zoomControlEnabled = false; //Deshabilitar barra para hacer zoom in y zoom out
		zoomControl.panControlEnabled = false;
        // write the map to container div
        map.write("mapdiv");
    });
