SET FOREIGN_KEY_CHECKS=0;

CREATE DATABASE IF NOT EXISTS control_asistencia;

USE control_asistencia;

DROP TABLE IF EXISTS asistencia;

CREATE TABLE `asistencia` (
  `idasistencia` int(11) NOT NULL AUTO_INCREMENT,
  `codigo_persona` varchar(20) COLLATE utf8_bin NOT NULL,
  `fecha_hora` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `tipo` varchar(45) COLLATE utf8_bin NOT NULL,
  `fecha` date NOT NULL,
  PRIMARY KEY (`idasistencia`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO asistencia VALUES("1","92","2022-10-26 11:46:11","Entrada","2022-10-26");
INSERT INTO asistencia VALUES("2","92","2022-10-26 11:46:18","Salida","2022-10-26");
INSERT INTO asistencia VALUES("3","RDP9FR","2022-10-26 11:53:09","Entrada","2022-10-26");
INSERT INTO asistencia VALUES("4","RDP9FR","2022-10-26 11:53:32","Salida","2022-10-26");
INSERT INTO asistencia VALUES("5","RDP9FR","2022-10-26 11:55:49","Entrada","2022-10-26");
INSERT INTO asistencia VALUES("6","RDP9FR","2022-10-26 11:55:57","Salida","2022-10-26");
INSERT INTO asistencia VALUES("7","RDP9FR","2022-10-26 11:56:03","Entrada","2022-10-26");
INSERT INTO asistencia VALUES("8","RDP9FR","2022-10-26 11:56:10","Salida","2022-10-26");
INSERT INTO asistencia VALUES("9","RDP9FR","2022-10-26 12:15:17","Entrada","2022-10-26");
INSERT INTO asistencia VALUES("10","RDP9FR","2022-10-26 12:15:23","Salida","2022-10-26");



DROP TABLE IF EXISTS departamento;

CREATE TABLE `departamento` (
  `iddepartamento` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(45) COLLATE utf8_bin NOT NULL,
  `descripcion` varchar(45) COLLATE utf8_bin NOT NULL,
  `fechacreada` datetime NOT NULL,
  `idusuario` varchar(45) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`iddepartamento`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO departamento VALUES("1","Créditos y cobranza","Asesores","2020-01-18 00:00:00","1");
INSERT INTO departamento VALUES("2","Ventas","trabajo de promoción","2020-01-19 00:15:24","1");
INSERT INTO departamento VALUES("3","Compras","Compras FR MEDICAL","2020-01-28 21:24:52","1");
INSERT INTO departamento VALUES("4","Recursos Humanos","encargado de RH","2020-01-28 21:25:08","1");
INSERT INTO departamento VALUES("5","Almacen","encargado de los movimientos de caja","2020-01-28 21:25:45","1");
INSERT INTO departamento VALUES("6","Vigilancia","vigilantes de FR MEDICAL","2020-01-28 21:26:14","1");
INSERT INTO departamento VALUES("7","Limpieza","encargado de la limpieza de oficinas","0000-00-00 00:00:00","1");
INSERT INTO departamento VALUES("8","Direccion","Dirección General De FR MEDICAL","2022-08-30 11:19:56","1");
INSERT INTO departamento VALUES("9","Sistemas","Sistemas FR","2022-08-30 11:20:05","1");



DROP TABLE IF EXISTS logs;

CREATE TABLE `logs` (
  `name` varchar(255) NOT NULL,
  `Time` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO logs VALUES("C","2022-03-27 23:37:02");
INSERT INTO logs VALUES("Calvin john placioBarangay papaya, Nasugbu,BatangasCisco network specialist Ulagain","2022-03-27 23:37:15");
INSERT INTO logs VALUES("Rodelyn F pondare","2022-03-27 23:46:17");
INSERT INTO logs VALUES("https://dione.batstate-u.edu.ph/student/backend/public/view/id_copy?jwt=eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzY2hvb2x5ZWFyIjoiMjAyMS0yMDIyIiwic2VtZXN0ZXIiOiJTRUNPTkQiLCJzcmNvZGUiOiIxOC0yOTgwOCJ9.F9YaT0lKJUdtqWReGCHVm0QmoosW_gXKGWt3VP1OWsU","2022-03-27 23:53:31");
INSERT INTO logs VALUES("RDP9FR","2022-10-13 13:59:25");
INSERT INTO logs VALUES("RDP10FR","2022-10-24 10:36:48");



DROP TABLE IF EXISTS mensajes;

CREATE TABLE `mensajes` (
  `idmensaje` int(11) NOT NULL AUTO_INCREMENT,
  `idusuariomensaje` int(11) NOT NULL,
  `textomensaje` text COLLATE utf8_bin NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT 1,
  `fechamensaje` datetime NOT NULL,
  `fechacreada` datetime NOT NULL,
  `idusuario` int(11) NOT NULL,
  PRIMARY KEY (`idmensaje`),
  KEY `idusuario` (`idusuario`),
  CONSTRAINT `mensajes_ibfk_1` FOREIGN KEY (`idusuario`) REFERENCES `usuarios` (`idusuario`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO mensajes VALUES("2","1","hola, esto es un mensaje de prueba del sistema de usuarios","1","2020-01-18 00:00:00","2020-01-18 00:00:00","1");



DROP TABLE IF EXISTS tipousuario;

CREATE TABLE `tipousuario` (
  `idtipousuario` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(45) COLLATE utf8_bin NOT NULL,
  `descripcion` varchar(80) COLLATE utf8_bin NOT NULL,
  `fechacreada` datetime NOT NULL,
  `idusuario` varchar(45) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`idtipousuario`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO tipousuario VALUES("1","Administrador","Con privilegios de gestionar todo el sistema e usuarios.","2020-01-18 00:00:00","1");
INSERT INTO tipousuario VALUES("2","Usuario","Ve sus propios registros, no tiene permiso administrativo.","2020-01-19 00:30:13","1");



DROP TABLE IF EXISTS usuarios;

CREATE TABLE `usuarios` (
  `idusuario` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(45) COLLATE utf8_bin NOT NULL,
  `apellidos` varchar(45) COLLATE utf8_bin NOT NULL,
  `login` varchar(45) COLLATE utf8_bin NOT NULL,
  `iddepartamento` int(11) NOT NULL,
  `idtipousuario` int(11) NOT NULL,
  `email` varchar(45) COLLATE utf8_bin NOT NULL,
  `password` varchar(64) COLLATE utf8_bin NOT NULL,
  `imagen` varchar(50) COLLATE utf8_bin NOT NULL,
  `estado` tinyint(4) NOT NULL DEFAULT 1,
  `fechacreado` datetime NOT NULL,
  `usuariocreado` varchar(45) COLLATE utf8_bin NOT NULL,
  `codigo_persona` varchar(20) COLLATE utf8_bin DEFAULT NULL,
  `idmensaje` int(11) NOT NULL,
  PRIMARY KEY (`idusuario`),
  UNIQUE KEY `login` (`login`),
  UNIQUE KEY `codigo_persona` (`codigo_persona`),
  KEY `fk_departamento` (`iddepartamento`),
  KEY `fk_tiposusario` (`idtipousuario`),
  CONSTRAINT `usuarios_ibfk_1` FOREIGN KEY (`iddepartamento`) REFERENCES `departamento` (`iddepartamento`),
  CONSTRAINT `usuarios_ibfk_2` FOREIGN KEY (`idtipousuario`) REFERENCES `tipousuario` (`idtipousuario`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO usuarios VALUES("1","Cristian Alexis","Torres Altuzar","soporteti","9","1","soporteti@frmedical.com.mx","845271951f36aea7a4f5e58859177e0c9d4f501431c25945eac7da26b0be19b6","1666363591.jpg","1","2020-01-18 00:00:00","Cristian Alexis","RDP9FR","1");
INSERT INTO usuarios VALUES("2","Jorge","Dominguez Dominguez","soporte","9","1","soporte@frmedical.com.mx","845271951f36aea7a4f5e58859177e0c9d4f501431c25945eac7da26b0be19b6","1661894704.jpg","1","2022-08-30 16:25:03","Jorge","RDP10FR","0");
INSERT INTO usuarios VALUES("16","Juan","López","juan","1","2","juan@frmedical.com.mx","5d9ca58b1623374ba0718e776bfe0a25a5f2e146447c964702138f44d21278e1","","1","2022-10-21 09:19:16","Juan","RDP11FR","0");
INSERT INTO usuarios VALUES("19","Luis Daniel","Torres Alvizo","ventassin","2","2","ventassin@frmedical.com.mx","845271951f36aea7a4f5e58859177e0c9d4f501431c25945eac7da26b0be19b6","","1","2022-10-26 10:57:30","Luis Daniel","92","0");



SET FOREIGN_KEY_CHECKS=1;